/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.utility.inventory.group;

import Krasnodar.rockstarnew.utility.inventory.ItemSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class SlotGroup<T extends ItemSlot> {
    protected final List<T> slots;

    public SlotGroup(List<T> slots) {
        this.slots = slots;
    }

    @Nullable
    public T findItem(class_1792 item) {
        return (T)((ItemSlot)this.slots.stream().filter(slot -> slot.contains(item)).findFirst().orElse(null));
    }

    @Nullable
    public T findItem(Predicate<class_1799> predicate) {
        return (T)((ItemSlot)this.slots.stream().filter(slot -> slot.matches(predicate)).findFirst().orElse(null));
    }

    public List<@Nullable T> findItems(class_1792 item) {
        return this.slots.stream().filter(slot -> slot.contains(item)).toList();
    }

    public List<@Nullable T> findItems(Predicate<class_1799> predicate) {
        return this.slots.stream().filter(slot -> slot.matches(predicate)).toList();
    }

    @Nullable
    public T findEmptySlot() {
        return (T)((ItemSlot)this.slots.stream().filter(ItemSlot::isEmpty).findFirst().orElse(null));
    }

    public boolean hasItem(class_1792 item) {
        return this.slots.stream().anyMatch(slot -> slot.contains(item));
    }

    public int countItems(class_1792 item) {
        return this.slots.stream().filter(slot -> slot.contains(item)).mapToInt(slot -> slot.itemStack().method_7947()).sum();
    }

    public SlotGroup<ItemSlot> and(SlotGroup<? extends ItemSlot> other) {
        ArrayList<T> combined = new ArrayList<T>(this.slots.size() + other.slots.size());
        combined.addAll(this.slots);
        combined.addAll(other.slots);
        return new SlotGroup<ItemSlot>(combined);
    }

    public SlotGroup<ItemSlot> and(ItemSlot slot) {
        ArrayList<T> combined = new ArrayList<T>(this.slots);
        combined.add(slot);
        return new SlotGroup<ItemSlot>(combined);
    }

    @Generated
    public List<T> getSlots() {
        return this.slots;
    }
}

